/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import java.util.HashMap;
import java.util.Iterator;

public class PoolContainer {
    private HashMap pools = new HashMap();

    public static void swap(PoolContainer container1, IncidentPool pool1, PoolContainer container2, IncidentPool pool2) {
        String keyA = container1.findKey(pool1);
        String keyB = container2.findKey(pool2);
        if (keyA == null || keyB == null) {
            throw new RuntimeException("One or both specified pool(s) do not exist in container, unable to swap");
        }
        IncidentPool poolA = container1.remove(pool1);
        IncidentPool poolB = container2.remove(pool2);
        if (container1.pools.containsKey(keyB) || container2.pools.containsKey(keyA)) {
            throw new RuntimeException("Swapping would cause a name conflict, unable to swap");
        }
        container1.add(poolB, keyB);
        container2.add(poolA, keyA);
    }

    public synchronized boolean add(IncidentPool pool, String name) {
        return this.pools.put(name, pool) == null;
    }

    public boolean add(String name) {
        return this.add(new IncidentPool(), name);
    }

    public IncidentPool get(String name) {
        return (IncidentPool)this.pools.get(name);
    }

    public synchronized IncidentPool remove(String name) {
        return (IncidentPool)this.pools.remove(name);
    }

    public synchronized IncidentPool remove(IncidentPool pool) {
        String key = this.findKey(pool);
        if (key != null) {
            return (IncidentPool)this.pools.remove(key);
        }
        return null;
    }

    public String findKey(IncidentPool pool) {
        if (this.pools.containsValue(pool)) {
            Iterator iterator = this.pools.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                if (pool != this.pools.get(key)) continue;
                return (String)key;
            }
        }
        return null;
    }

    public synchronized Iterator iterator() {
        return ((HashMap)this.pools.clone()).values().iterator();
    }

    public synchronized Iterator keyIterator() {
        return ((HashMap)this.pools.clone()).keySet().iterator();
    }

    public synchronized void clear() {
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            ((IncidentPool)iterator.next()).clear();
        }
        this.pools.clear();
    }
}

